/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPROUTINGINDICATION_H
#define QKNXNETIPROUTINGINDICATION_H

#include <QtKnx/qknxlinklayerframe.h>
#include <QtKnx/qknxnetip.h>
#include <QtKnx/qknxnetipframe.h>
#include <QtKnx/qtknxglobal.h>

QT_BEGIN_NAMESPACE

class Q_KNX_EXPORT QKnxNetIpRoutingIndicationProxy final
{
public:
    QKnxNetIpRoutingIndicationProxy() = delete;
    ~QKnxNetIpRoutingIndicationProxy() = default;

    QKnxNetIpRoutingIndicationProxy(const QKnxNetIpFrame &&) = delete;
    explicit QKnxNetIpRoutingIndicationProxy(const QKnxNetIpFrame &frame);

    bool isValid() const;

    QKnxLinkLayerFrame cemi() const;
#if QT_DEPRECATED_SINCE(5, 12)
    QT_DEPRECATED QKnxLinkLayerFrame linkLayerFrame() const;
#endif

    class Q_KNX_EXPORT Builder final
    {
    public:
        Builder &setCemi(const QKnxLinkLayerFrame &cemi);
#if QT_DEPRECATED_SINCE(5, 12)
        QT_DEPRECATED Builder &setLinkLayerFrame(const QKnxLinkLayerFrame &llf);
#endif

        QKnxNetIpFrame create() const;

    private:
        QKnxLinkLayerFrame m_llf;
    };
    static QKnxNetIpRoutingIndicationProxy::Builder builder();

private:
    const QKnxNetIpFrame &m_frame;
};

QT_END_NAMESPACE

#endif
